<?php
// save_points.php
// Diese Datei speichert empfangene Punkte-Daten in einem Ordner

// Header für CORS (Cross-Origin Resource Sharing) setzen
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

// Prüfen, ob es sich um eine POST-Anfrage handelt
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // JSON-Daten aus dem Request-Body lesen
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);
    
    // Validierung der Daten
    if (!$data || !isset($data['email']) || !isset($data['points'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Ungültige Daten']);
        exit;
    }
    
    $email = $data['email'];
    $note = $data['note'] ?? '';
    $points = $data['points'];
    $timestamp = $data['timestamp'] ?? date('c');
    
    // E-Mail-Validierung
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        http_response_code(400);
        echo json_encode(['error' => 'Ungültige E-Mail-Adresse']);
        exit;
    }
    
    // Zielordner für die Dateien
    $targetDir = '../pointuploads/';
    
    // Ordner erstellen, falls nicht vorhanden
    if (!is_dir($targetDir)) {
        mkdir($targetDir, 0755, true);
    }
    
    // Dateiname erstellen (E-Mail + Zeitstempel)
    $safeEmail = preg_replace('/[^a-zA-Z0-9]/', '_', $email);
    $filename = date('Y-m-d_His') . $safeEmail . '_' . '.json';
    $filepath = $targetDir . $filename;
    
    // Daten für die Datei vorbereiten
    $fileData = [
        'email' => $email,
        'note' => $note,
        'points' => $points,
        'received_at' => $timestamp,
        'point_count' => count($points)
    ];
    
    // Datei schreiben
    if (file_put_contents($filepath, json_encode($fileData, JSON_PRETTY_PRINT))) {
        // Erfolgsmeldung zurückgeben
        echo json_encode([
            'success' => true,
            'message' => 'Daten erfolgreich gespeichert',
            'filename' => $filename,
            'point_count' => count($points)
        ]);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'Fehler beim Speichern der Daten']);
    }
    
} elseif ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    // Preflight-Request für CORS
    exit(0);
} else {
    http_response_code(405);
    echo json_encode(['error' => 'Methode nicht erlaubt']);
}
?>