<?php
/**
 * CSS/JS Inline-Loader für acampi.html
 * Ersetzt externe CSS/JS-Dateien mit ./ Pfad durch ihren Inhalt
 */

function loadAndProcessHTML($htmlFile) {
    // HTML-Datei einlesen
    if (!file_exists($htmlFile)) {
        die("Fehler: HTML-Datei '$htmlFile' nicht gefunden.");
    }
    
    $htmlContent = file_get_contents($htmlFile);
    
    // CSS-Dateien finden und ersetzen
    $htmlContent = replaceCSSFiles($htmlContent);
    
    // JavaScript-Dateien finden und ersetzen
    $htmlContent = replaceJSFiles($htmlContent);
    
    return $htmlContent;
}

function replaceCSSFiles($htmlContent) {
    // Regex für CSS-Links mit ./ am Anfang
    $pattern = '/<link\s+[^>]*rel=("|\')stylesheet\1[^>]*href=("|\')\.\/([^"\']+\.css)\2[^>]*\/?>/i';
    
    return preg_replace_callback($pattern, function($matches) {
        $cssFile = $matches[3]; // Dateiname ohne ./
        
        if (file_exists($cssFile)) {
            $cssContent = file_get_contents($cssFile);
            // CSS in style-Tags einbetten
            return "<style>\n" . $cssContent . "\n</style>";
        } else {
            // Datei nicht gefunden - Original-Tag beibehalten
            error_log("Warnung: CSS-Datei '$cssFile' nicht gefunden.");
            return $matches[0];
        }
    }, $htmlContent);
}

function replaceJSFiles($htmlContent) {
    // Regex für JavaScript-Dateien mit ./ am Anfang
    $pattern = '/<script\s+[^>]*src=("|\')\.\/([^"\']+\.js)\1[^>]*><\/script>/i';
    
    return preg_replace_callback($pattern, function($matches) {
        $jsFile = $matches[2]; // Dateiname ohne ./
        
        if (file_exists($jsFile)) {
            $jsContent = file_get_contents($jsFile);
            // JavaScript in script-Tags einbetten
            return "<script>\n" . $jsContent . "\n</script>";
        } else {
            // Datei nicht gefunden - Original-Tag beibehalten
            error_log("Warnung: JS-Datei '$jsFile' nicht gefunden.");
            return $matches[0];
        }
    }, $htmlContent);
}

// Hauptprogramm
try {
    // HTML-Datei verarbeiten
    $processedHTML = loadAndProcessHTML('acampi.html');
    
    // Content-Type setzen
    header('Content-Type: text/html; charset=utf-8');
    
    // Verarbeitetes HTML ausgeben
    echo $processedHTML;
    
} catch (Exception $e) {
    header('Content-Type: text/html; charset=utf-8');
    echo "<!DOCTYPE html><html><head><title>Fehler</title></head><body>";
    echo "<h1>Fehler beim Verarbeiten der HTML-Datei</h1>";
    echo "<p>" . htmlspecialchars($e->getMessage()) . "</p>";
    echo "</body></html>";
}
?>